-- Create the scs and admin users
-- The password(s) must be set to the correct value before using!

CREATE USER IF NOT EXISTS 'scs'@'%' IDENTIFIED BY 'scspasswordgoeshere'; 

GRANT DELETE, EXECUTE, INSERT, SELECT, UPDATE, EVENT, SHOW VIEW ON `scs`.* TO 'scs'@'%';

-- ALTER GRANTS for dropping and recreating display name unique indexes when saving the working configuration
GRANT ALTER ON `scs`.`sensor_interface` TO 'scs'@'%';
GRANT ALTER ON `scs`.`message_definition` TO 'scs'@'%';
GRANT ALTER ON `scs`.`data_field_definition` TO 'scs'@'%';
GRANT ALTER ON `scs`.`physical_device` TO 'scs'@'%';
GRANT ALTER ON `scs`.`device_image` TO 'scs'@'%';

/*
 * Grant global select privileges.
 * The default behavior for EF function imports is to "check parameters against the server" which requires the user to have access to system views/tables.
 * If the user does not have global select privileges unhelpful errors can be thrown when attempting to execute function imports
 * e.g. "SqlNullValueException: Data is Null. This method or property cannot be called on Null values."  when attempting to execute get_reference_id_from_user_value
 */
GRANT SELECT ON *.* TO 'scs'@'%';

-- Grant RELOAD to facilitate log maintenance
GRANT RELOAD ON *.* TO 'scs'@'%';

CREATE USER IF NOT EXISTS 'admin'@'%' IDENTIFIED BY 'adminpasswordgoeshere'; 

GRANT ALL ON *.* TO 'admin'@'%';
GRANT GRANT OPTION ON *.* TO 'admin'@'%';

FLUSH PRIVILEGES;